/*
 * Decompiled with CFR 0.152.
 */
package ys.pingu;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ys.pingu.PinguMIDlet;
import ys.pingu.PinguScores;
import ys.pingu.PinguSprites;

public class PinguCanvas
extends Canvas
implements CommandListener,
Runnable {
    public static final int IMAGE_WIDTH = 176;
    public static final int IMAGE_HEIGHT = 144;
    public static Graphics GC;
    public static int GAMESTATE;
    public static int GAMECOUNT;
    public static int HIGHSCORE;
    public static int SCORE;
    public static final int STATE_YETIWAITING = 0;
    public static final int STATE_PINGUDANCING = 1;
    public static final int STATE_PINGUJUMPING = 2;
    public static final int STATE_PITCH = 3;
    public static final int STATE_PINGUFLYING = 4;
    public static final int STATE_SCOREACCEPT = 5;
    private static final Font GAME_FONT;
    private static final int ANCHOR = 20;
    private static final int MILLIS_PER_TICK = 40;
    private static final int GAMECOUNT_MAX = 5;
    private volatile Thread animationThread = null;
    private final Command backCommand;
    private PinguSprites sprites;
    private PinguMIDlet parent;
    private Image currentFrame;
    private boolean keyHit;
    private boolean ignoreKeyHit;

    public PinguCanvas(PinguMIDlet parent) {
        this.parent = parent;
        this.currentFrame = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        GC = this.currentFrame.getGraphics();
        GC.setFont(GAME_FONT);
        this.sprites = new PinguSprites();
        GAMECOUNT = 0;
        HIGHSCORE = 0;
        SCORE = 0;
        this.setCommandListener(this);
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
    }

    public void init() {
        GAMESTATE = 0;
        GAMECOUNT = 0;
        HIGHSCORE = 0;
        SCORE = 0;
        this.keyHit = false;
        this.ignoreKeyHit = true;
        this.sprites.init();
    }

    public void continueGame() {
        this.ignoreKeyHit = true;
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTaken;
                if (currentThread != this.animationThread) {
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown()) {
                    this.tick();
                    this.repaint();
                }
                if ((timeTaken = System.currentTimeMillis() - startTime) < 40L) {
                    PinguCanvas pinguCanvas = this;
                    synchronized (pinguCanvas) {
                        this.wait(40L - timeTaken);
                        continue;
                    }
                }
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            this.stop();
            this.parent.pinguCanvasMenu();
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.ignoreKeyHit) {
            this.ignoreKeyHit = false;
            return;
        }
        this.keyHit = true;
    }

    protected void paint(Graphics g) {
        if (this.currentFrame != null) {
            g.drawImage(this.currentFrame, 0, 0, 20);
        }
    }

    private void tick() {
        if (this.keyHit && GAMESTATE == 0) {
            this.keyHit = false;
            GAMESTATE = 1;
        } else if (GAMESTATE != 1) {
            if (GAMESTATE == 2) {
                GAMESTATE = 3;
                this.sprites.setHitable();
            } else if (this.keyHit && GAMESTATE == 3) {
                this.keyHit = false;
                this.sprites.hit();
            } else if (GAMESTATE != 4 && this.keyHit && GAMESTATE == 5) {
                this.keyHit = false;
                HIGHSCORE += SCORE;
                if (++GAMECOUNT < 5) {
                    GAMESTATE = 0;
                    SCORE = 0;
                    this.sprites.init();
                } else {
                    int h = HIGHSCORE;
                    this.init();
                    if (PinguScores.isHighScore(h)) {
                        this.stop();
                        this.parent.pinguCanvasEnterHighScore(h);
                    }
                }
            }
        }
        this.sprites.draw();
    }

    static {
        IMAGE_WIDTH = 176;
        IMAGE_HEIGHT = 144;
        STATE_YETIWAITING = 0;
        STATE_PINGUDANCING = 1;
        STATE_PINGUJUMPING = 2;
        STATE_PITCH = 3;
        STATE_PINGUFLYING = 4;
        STATE_SCOREACCEPT = 5;
        GAME_FONT = Font.getFont((int)0, (int)1, (int)0);
        ANCHOR = 20;
        MILLIS_PER_TICK = 40;
        GAMECOUNT_MAX = 5;
    }
}

