/*
 * Decompiled with CFR 0.152.
 */
package ys.pingu;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import ys.pingu.PinguCanvas;
import ys.pingu.PinguEnterHigh;
import ys.pingu.PinguHelp;
import ys.pingu.PinguHigh;
import ys.pingu.PinguMenu;
import ys.pingu.PinguScores;
import ys.pingu.PinguSplash;

public class PinguMIDlet
extends MIDlet
implements Runnable {
    private static final String helpString = "Press any key to let pingu jump.\nPress any key to pitch the pingu.\n\nYou need 5 hits to score. The highscore lists only the best 5 scores.";
    private static final String aboutString = "Yetisports Part1\n\n\u00a9 2004 Chris Hilgert,\nported to J2ME by manuel g.\n\nAll rights reserved\nEdelweiss medienwerkst.at\nwww.yetisports.org";
    public static PinguScores pinguScores;
    private PinguMenu pinguMenu;
    private PinguHelp pinguHelp;
    private PinguHigh pinguHigh;
    private PinguEnterHigh pinguEnterHigh;
    private PinguCanvas pinguCanvas;
    private boolean initDone = false;

    public void startApp() {
        Displayable current = Display.getDisplay((MIDlet)this).getCurrent();
        if (current == null) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new PinguSplash(this));
        } else {
            if (current == this.pinguCanvas) {
                this.pinguCanvas.start();
            }
            Display.getDisplay((MIDlet)this).setCurrent(current);
        }
    }

    public void pauseApp() {
        Displayable current = Display.getDisplay((MIDlet)this).getCurrent();
        if (current == this.pinguCanvas) {
            this.pinguCanvas.stop();
        }
    }

    public void destroyApp(boolean unconditional) {
        if (this.pinguCanvas != null) {
            this.pinguCanvas.stop();
        }
        PinguScores.doFinalize();
    }

    private void quit() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void run() {
        this.init();
    }

    private synchronized void init() {
        if (!this.initDone) {
            pinguScores = new PinguScores();
            this.pinguMenu = new PinguMenu(this);
            this.pinguCanvas = new PinguCanvas(this);
            this.initDone = true;
        }
    }

    void splashScreenPainted() {
        new Thread(this).start();
    }

    void splashScreenDone() {
        this.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguMenu);
    }

    void pinguMenuContinue() {
        this.pinguCanvas.continueGame();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguCanvas);
        this.pinguCanvas.start();
    }

    void pinguMenuNewGame() {
        this.pinguCanvas.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguCanvas);
        this.pinguCanvas.start();
    }

    void pinguMenuHelp(int type) {
        if (type == 0) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new PinguHelp(this, "Instructions", helpString));
        } else {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)new PinguHelp(this, "About", aboutString));
        }
    }

    void pinguMenuHigh() {
        if (this.pinguHigh == null) {
            this.pinguHigh = new PinguHigh(this);
        }
        this.pinguHigh.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguHigh);
    }

    void pinguMenuQuit() {
        this.quit();
    }

    void pinguCanvasMenu() {
        this.pinguCanvas.stop();
        this.pinguMenu.setGameActive(true);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguMenu);
    }

    void pinguCanvasEnterHighScore(int hscore) {
        this.pinguCanvas.stop();
        this.pinguEnterHigh = null;
        this.pinguEnterHigh = new PinguEnterHigh(this, hscore);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguEnterHigh);
    }

    void pinguEnterHighFinished() {
        this.pinguEnterHigh = null;
        this.pinguMenuNewGame();
    }

    void pinguHelpBack() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguMenu);
    }

    void pinguHighBack() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.pinguMenu);
    }

    static Image loadImage(String name) {
        Image img = null;
        try {
            img = Image.createImage((String)name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    static {
        helpString = helpString;
        aboutString = aboutString;
    }
}

