/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

class QScore {
    public static final int NUM_RECORDS = 5;
    private static RecordStore rs = null;
    private static int[] scoreScore = new int[5];
    private static int[] scoreDirty = new int[5];
    private static String[] scoreName = new String[5];

    private QScore() {
    }

    public static void initialize() {
        for (int i = 0; i < 5; ++i) {
            QScore.scoreScore[i] = 0;
            QScore.scoreDirty[i] = 0;
            QScore.scoreName[i] = QRes.getText("n/a");
        }
        QScore.close();
        if (!QScore.init()) {
            QScore.close();
        } else if (!QScore.read()) {
            QScore.close();
        }
    }

    public static void save() {
        QScore.write(true);
        QScore.close();
    }

    public static void setScore(String string, int n, int n2) {
        for (int i = 0; i < 5; ++i) {
            if (n <= scoreScore[i]) continue;
            for (int j = 4; j > i; --j) {
                if (scoreScore[j - 1] <= 0) continue;
                QScore.scoreName[j] = scoreName[j - 1];
                QScore.scoreScore[j] = scoreScore[j - 1];
                QScore.scoreDirty[j] = scoreDirty[j - 1];
            }
            QScore.scoreName[i] = string != null ? string : QRes.getText("n/a");
            QScore.scoreScore[i] = n;
            QScore.scoreDirty[i] = n2;
            break;
        }
    }

    public static void setDirty(int n, int n2) {
        if (n >= 0 && n < 5) {
            QScore.scoreDirty[n] = n2;
        }
    }

    public static boolean isDirty(int n) {
        if (n >= 0 && n < 5) {
            return scoreDirty[n] != 0;
        }
        return false;
    }

    public static int getScore(int n) {
        if (n >= 0 && n < 5) {
            return scoreScore[n];
        }
        return 0;
    }

    public static String getScoreName(int n) {
        if (n >= 0 && n < 5) {
            return scoreName[n];
        }
        return QRes.getText("n/a");
    }

    public static boolean isHighScore(int n) {
        if (n > 0) {
            for (int i = 0; i < 5; ++i) {
                if (n <= scoreScore[i]) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean init() {
        boolean bl = true;
        try {
            rs = RecordStore.openRecordStore((String)"PinguScores", (boolean)true);
            if (rs.getNumRecords() != 5) {
                rs.closeRecordStore();
                rs = null;
                RecordStore.deleteRecordStore((String)"PinguScores");
                rs = RecordStore.openRecordStore((String)"PinguScores", (boolean)true);
                bl = QScore.write(false);
            }
        }
        catch (RecordStoreException recordStoreException) {
            bl = false;
        }
        return bl;
    }

    private static boolean read() {
        boolean bl = true;
        if (rs == null) {
            bl = false;
        } else {
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            for (int i = 0; i < 5; ++i) {
                if (!bl) continue;
                try {
                    byteArrayInputStream = new ByteArrayInputStream(rs.getRecord(i + 1));
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    try {
                        QScore.scoreScore[i] = dataInputStream.readInt();
                        QScore.scoreDirty[i] = dataInputStream.readInt();
                        QScore.scoreName[i] = dataInputStream.readUTF();
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                    continue;
                }
                catch (RecordStoreException recordStoreException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private static boolean write(boolean bl) {
        boolean bl2 = true;
        if (rs == null) {
            bl2 = false;
        } else {
            ByteArrayOutputStream byteArrayOutputStream = null;
            DataOutputStream dataOutputStream = null;
            for (int i = 0; i < 5; ++i) {
                if (!bl2) continue;
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeInt(scoreScore[i]);
                    dataOutputStream.writeInt(scoreDirty[i]);
                    dataOutputStream.writeUTF(scoreName[i]);
                }
                catch (IOException iOException) {
                    bl2 = false;
                }
                if (!bl2) continue;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                try {
                    if (bl) {
                        rs.setRecord(i + 1, byArray, 0, byArray.length);
                        continue;
                    }
                    rs.addRecord(byArray, 0, byArray.length);
                    continue;
                }
                catch (RecordStoreException recordStoreException) {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private static void close() {
        if (rs != null) {
            try {
                rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            rs = null;
        }
    }
}

